//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Inflows excluding only children
// Objective: 	Calculate the aggregate value of inheritances received by year,
//				excluding only children.
//
// Created: 	30/06/2021
// Modified: 	15/11/2021
//==============================================================================

**************************
*** Importing the Data ***
**************************

clear

cd "XXXX"	// Set the content directory here.

use HILDA_restricted_combined_rescaled	// Importing the unconfidentialised data that includes the new weights.

merge 1:1 xwaveid wave using "first_estate_bequest.dta", nogen

drop if first_estate_bequest == 1

// keep if (wave == 8 | wave == 12 | wave == 19)

xtset xwaveid wave	// declaring the dataset to be a panel

* generating a siblings variable (only available in some waves, so other waves have been imputed)
gen siblings = .
replace siblings = bsn if (wave == 8 | wave == 12 | wave == 19)
replace siblings = F7.bsn if wave == 1 & F7.bsn != .
replace siblings = F6.bsn if wave == 2 & F6.bsn != .
replace siblings = F5.bsn if wave == 3 & F5.bsn != .
replace siblings = F4.bsn if wave == 4 & F4.bsn != .
replace siblings = F3.bsn if wave == 5 & F3.bsn != .
replace siblings = F2.bsn if wave == 6 & F2.bsn != .
replace siblings = F.bsn if wave == 7 & F.bsn != .
replace siblings = L.bsn if wave == 9 & L.bsn != .
replace siblings = F3.bsn if wave == 9 & L.bsn == . & F3.bsn != .
replace siblings = L2.bsn if wave == 10 & L2.bsn != .
replace siblings = F2.bsn if wave == 10 & L2.bsn == . & F2.bsn != .
replace siblings = F.bsn if wave == 11 & F.bsn != .
replace siblings = L3.bsn if wave == 11 & F.bsn == . & L3.bsn != .
replace siblings = L.bsn if wave == 13 & L.bsn != .
replace siblings = F6.bsn if wave == 13 & L.bsn == . & F6.bsn != .
replace siblings = L2.bsn if wave == 14 & L2.bsn != .
replace siblings = F5.bsn if wave == 14 & L2.bsn == . & F5.bsn != .
replace siblings = L3.bsn if wave == 15 & L3.bsn != .
replace siblings = F4.bsn if wave == 15 & L3.bsn == . & F4.bsn != .
replace siblings = F3.bsn if wave == 16 & F3.bsn != .
replace siblings = L4.bsn if wave == 16 & F3.bsn == . & L4.bsn != .
replace siblings = F2.bsn if wave == 17 & F2.bsn != .
replace siblings = L5.bsn if wave == 17 & F2.bsn == . & L5.bsn != . 
replace siblings = F.bsn if wave == 18 & F.bsn != .
replace siblings = L6.bsn if wave == 18 & F.bsn == . & L6.bsn != .
replace siblings = 0 if siblings == -1
replace siblings = . if siblings < 0

replace oifinh = 0 if oifinh <= 0	// replacing negative values of inheritance indicator as zero
replace oifinha = 0 if oifinha <= 0	// replacing negative values of inheritance as zero

replace benchmarked_new_hhwtrp = 0 if benchmarked_new_hhwtrp <= 0

gen inheritance = oifinha * benchmarked_new_hhwtrp	// applying the population weights

drop if siblings == 0

by wave, sort: egen sum = sum(inheritance)	// calculating aggregate inheritances received

keep wave sum

collapse sum, by(wave)

save siblings_sum_bequest, replace

save inflows_excluding_only_children.dta, replace